<?php

namespace App\Http\Controllers;

use App\Models\AutoSwitching;
use App\Models\BillingData;
use App\Models\Dbbox;
use App\Models\DeviceConfiguration;
use App\Models\DeviceThreshold;
use App\Models\Event;
use App\Models\Feeder;
use App\Models\KwhReading;
use App\Models\LoadProfileData;
use App\Models\MeterVisual;
use App\Models\RawTransLog;
use App\Models\Reading;
use App\Models\Transformer;
use App\Models\TrappingEventSetting;
use App\Models\TrCurrentLog;
use App\Models\TrKwhLog;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;

class ReportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    // public function index()
    // {
    //     // dd(auth()->user());
    //     $data['t_trans']=MeterVisual::count();
    //     $data['i_trans']=MeterVisual::where('auxr_status',1)->count();
    //     $data['o_trans']=MeterVisual::where('auxr_status',0)->count();
    //     return view('home',compact('data'));
    // }
 


    // public function dataList()
    // {
    //     $data=MeterVisual::get();
    //     return view('list',compact('data'));
    // }

    // public function getCofiguration($id)
    // {
    //     $data=DeviceConfiguration::where('global_device_id',$id)->first();
    //     return response()->json($data);
    // }

   

  
    
    

    // public function dataItem($id)
    // {
    //     $data=MeterVisual::select('id','global_device_id')->where('global_device_id',$id)->first();
    //     // $graph_data=LoadProfileData::get();
    //     // dd($data);

    //     return view('single-item-chart',compact('data'));
    // }

    // public function ItemRealTimeData($id)
    // {
    //     $data=MeterVisual::select('id','global_device_id')->where('global_device_id',$id)->first();
    //     $graph_data=DB::table('tr_current_logs')->where('global_device_id',$id)->orderBy('id','desc')->limit(10)->get();
    //     // $graph_data=LoadProfileData::get();
    //     // dd($data);

    //     return view('single-item-real-time-data',compact('data','graph_data'));
    // }

    // public function itemGraphDataAjax($id,$time=0)
    // {
    //     // dd('testing');
    //     // $data=MeterVisual::find($id);
    //     $graph_data=RawTransLog::select('server_date_time','i_red as ca','i_blue as cb','i_yellow as cc','v_red as va','v_blue as vb' ,'v_yellow as vc')->where('moduleid',$id);
    //     // echo(json_encode($graph_data));
    //     // die;
    //     if($time !=0){
    //         if ($time == 'lh') {
    //             // Filter records from the last hour
    //             $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subHour());
    //         }

    //         if ($time == 'l24h') {
    //             // Filter records from the last 24 hours
    //             $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subDay());
    //         }

    //         if ($time == 'lw') {
    //             // Filter records from the last week
    //             $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subWeek());
    //         }

    //         if ($time == 'lm') {
    //             // Filter records from the last month
    //             $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subMonth());
    //         }

    //         // if ($time == 'c') {
    //             //     // Custom filter logic, for example:
    //                 //     // You might need to define start and end dates based on user input or other criteria
    //                 //     // Here we assume a custom range for demonstration purposes
    //                 //     $start_date = '2024-01-01 00:00:00'; // Example start date
    //                 //     $end_date = '2024-01-31 23:59:59'; // Example end date
    //                 //     $graph_data = $graph_data->whereBetween('db_datetime', [$start_date, $end_date]);
    //                 // }

    //             }
    //     $graph=$graph_data->get();
    //     // pr($graph);
    //     return result(1,'',$graph);
    //     // dd($data);

    //     // return view('single-item-chart',compact('data'));
    // }
                private function buildHierarchyWithLogs($node)
            {
                // Get logs for this node
                $logs = DB::table('tr_current_logs')
                        ->where('global_device_id', $node->global_device_id)
                        ->orderBy('stime','Desc')
                        ->first();

                // Recursively process children
                $children = $node->children->map(function ($child) {
                    return $this->buildHierarchyWithLogs($child);
                });

                return [
                    'id' => $node->id,
                    'global_device_id' => $node->global_device_id,
                    'logs' => $logs,
                    'children' => $children,
                ];
            }

            // Helper for recursive eager loading string
            private function recursiveChildrenString($depth = 5)
            {
                return implode('.', array_fill(0, $depth, 'children'));
            }
    
    // public function technicalReportForm(Request $request)
    // {

    //         $tr_data=MeterVisual::where('installed_on','transformer')->select('global_device_id','installed_on')->get();
    //         $data = [];
    //         $graph_data=[];
    //                         if ($request->DeviceId) {
    //                             // Get transformer meter info
    //                             $transformer = MeterVisual::where('global_device_id', $request->DeviceId)
    //                             ->with('children')
    //                             ->first();

    //                         if (!$transformer) {
    //                             return response()->json(['error' => 'Transformer not found'], 404);
    //                         }

    //                         $transformer->load($this->recursiveChildrenString(6)); // load deep children

    //                         $data = $this->buildHierarchyWithLogs($transformer);

    //                             // dd($data);

    //                             if($data )
    //                             {

    //                                 $logs=$data['logs'];
                                    
                                    
    //                                 if($data && $data['children'] )
    //                                 {
                                        
    //                                     foreach($data['children'] as $row)
    //                                     {
    //                                         if($row && $row['children'] )
    //                                         {
    //                                             foreach($row['children'] as $childrow)
    //                                             {
    //                                                 $grow=[];
    //                                                         $logs2=$childrow['logs'];
    //                                                         $logs2->stime;
    //                                                         $grow['stime']=$logs2->stime;
    //                                                         $grow['parent_id']=$logs->global_device_id;
    //                                                         // $logs->global_device_id;
    //                                                         $grow['child_id']=$logs2->global_device_id;
    //                                                         $grow['v1_difference']=$logs2->v1-$logs->v1;
    //                                                         $grow['v2_difference']=$logs2->v2-$logs->v2;
    //                                                         $grow['v3_difference']=$logs2->v3-$logs->v3;

    //                                                         $graph_data[]=$grow;
    //                                                     }
    //                                                 }
                                                    
                                                    
                                                    
    //                                             }	
    //                                         }
                                            
                                            
    //                             }
                      
    //                 }
    //                 // dd($graph_data);


    //     return view('technicalReportView',compact('data','tr_data','graph_data'));
    // }
    public function technicalReportForm(Request $request)
    {

            // $tr_data=MeterVisual::where('installed_on','transformer')->where('category','STB')->select('global_device_id','installed_on','kva')->get();
            $graph_data=[];
                            // if ($request->DeviceId) 
                            // {
                            //     $transformer = MeterVisual::where('global_device_id', $request->DeviceId)->get();
                            // }
                            // else
                            // {
                                // $transformer = MeterVisual::where('installed_on','transformer')->where('category','STB')->get();
                            // }

                            // if (!$transformer) {
                            //     return response()->json(['error' => 'Transformer not found'], 404);
                            // }

                            // foreach ($transformer as $key => $value) {
                            //     $graph_data[]=DB::table('tr_current_logs')
                            //                     ->where('global_device_id', $value->global_device_id)
                            //                     ->orderBy('stime','Desc')
                            //                     ->first();
                            //     // $graph_data[]=['global_device_id'=>$lg->global_device_id,'v1_difference'=>abs(240-$lg->v1),'v2_difference'=>abs(240-$lg->v2),'v3_difference'=>abs(240-$lg->v3)];
                            // }

                            $graph_data2=[];
                                            // if ($request->DeviceId) 
                                            // {
                                            //     $transformer2 = MeterVisual::where('global_device_id', $request->DeviceId)->get();
                                            // }
                                            // else
                                            // {
                                                $transformer2 = MeterVisual::select('global_device_id','installed_on','id')->where('installed_on','transformer')->where('category','STDB')->get();
                                            // }
                                           
                                            if (!$transformer2) {
                                                return response()->json(['error' => 'Transformer not found'], 404);
                                            }
                
                                            $logs2=[];
                                            foreach ($transformer2 as $key => $value) {
                                                // Get parent transformer latest log
                                                $lg1 = DB::table('tr_current_logs')
                                                    ->where('global_device_id', $value->global_device_id)
                                                    ->orderBy('stime', 'desc')
                                                    ->first();
                                            
                                                $v1_list = [];
                                                $v2_list = [];
                                                $v3_list = [];
                                            
                                                // Get child devices
                                                $childdevice = MeterVisual::where('installed_on', 'normal')
                                                    ->where('category', 'NOR')
                                                    ->where('parent_id', $value->id)
                                                    ->get();
                                                   
                                            
                                                foreach ($childdevice as $value2) {
                                                    $lg2 = DB::table('tr_current_logs')
                                                        ->where('global_device_id', $value2->global_device_id)
                                                        ->orderBy('stime', 'desc')
                                                        ->first();
                                                        // dd($lg2);
                                            
                                                    if ($lg2) {
                                                        // Extract CN number from global_device_id
                                                        if (preg_match('/CN(\d+)$/', $value2->global_device_id, $matches)) {
                                                            $cnNumber = (int)$matches[1];
                                                            $phase = $cnNumber % 3;

                                                            // echo $cnNumber.'\n';

                                            
                                                            // Assign to correct voltage list
                                                            if ($phase == 1) {
                                                                $v1_list[] = $lg2->v1 ?? 0;
                                                            } elseif ($phase == 2) {
                                                                $v2_list[] = $lg2->v2 ?? 0;
                                                            } else { // phase == 0 (e.g., CN3, CN6, CN9)
                                                                $v3_list[] = $lg2->v3 ?? 0;
                                                            }
                                                        }
                                                    }
                                                }

                                                // dd($v1_list);
                                            
                                                // Calculate averages
                                                $avg_v1 = count($v1_list) > 0 ? array_sum($v1_list) / count($v1_list) : 0;
                                                $avg_v2 = count($v2_list) > 0 ? array_sum($v2_list) / count($v2_list) : 0;
                                                $avg_v3 = count($v3_list) > 0 ? array_sum($v3_list) / count($v3_list) : 0;
                                            
                                                if ($lg1) {
                                                    $graph_data2[] = (object)[
                                                        'global_device_id' => $value->global_device_id,
                                                        'v1' => $avg_v1 !== 0 ? abs($lg1->v1 - $avg_v1) : 0,
                                                        'v2' => $avg_v2 !== 0 ? abs($lg1->v2 - $avg_v2) : 0,
                                                        'v3' => $avg_v3 !== 0 ? abs($lg1->v3 - $avg_v3) : 0,
                                                    ];
                                                }
                                            }
                                            
                      
                    // dd($graph_data2);


        return view('technicalReportView',compact('graph_data','graph_data2'));
    }
    public function commercialReportForm(Request $request)
    {

            // $tr_data=MeterVisual::where('installed_on','transformer')->where('category','STB')->select('global_device_id','installed_on','kva')->get();
            $graph_data=[];
                            // if ($request->DeviceId) 
                            // {
                            //     $transformer = MeterVisual::where('global_device_id', $request->DeviceId)->get();
                            // }
                            // else
                            // {
                                // $transformer = MeterVisual::where('installed_on','transformer')->where('category','STB')->get();
                            // }

                            // if (!$transformer) {
                            //     return response()->json(['error' => 'Transformer not found'], 404);
                            // }

                            // foreach ($transformer as $key => $value) {
                            //     $graph_data[]=DB::table('tr_current_logs')
                            //                     ->where('global_device_id', $value->global_device_id)
                            //                     ->orderBy('stime','Desc')
                            //                     ->first();
                            //     // $graph_data[]=['global_device_id'=>$lg->global_device_id,'v1_difference'=>abs(240-$lg->v1),'v2_difference'=>abs(240-$lg->v2),'v3_difference'=>abs(240-$lg->v3)];
                            // }

                            $graph_data2=[];
                                            // if ($request->DeviceId) 
                                            // {
                                            //     $transformer2 = MeterVisual::where('global_device_id', $request->DeviceId)->get();
                                            // }
                                            // else
                                            // {
                                                $transformer2 = MeterVisual::select('global_device_id','installed_on','id')->where('installed_on','transformer')->where('category','STDB')->get();
                                            // }
                                            // dd($transformer2);
                                           
                                            if (!$transformer2) {
                                                return response()->json(['error' => 'Transformer not found'], 404);
                                            }
                
                                            $logs2=[];
                                            foreach ($transformer2 as $key => $value) {
                                                // Get parent transformer latest log
                                                $lg1 = DB::table('tr_current_logs')->select('v1','v2','v3','i1','i2','i3','stime','global_device_id')
                                                    ->where('global_device_id', $value->global_device_id)
                                                    ->orderBy('stime', 'desc')
                                                    ->first();

                                                    
                                            
                                                $i1_list = [];
                                                $i2_list = [];
                                                $i3_list = [];
                                            
                                                // Get child devices
                                                $childdevice = MeterVisual::where('installed_on', 'normal')
                                                    ->select('category','id','global_device_id')
                                                    ->where('category', 'NOR')
                                                    ->where('parent_id', $value->id)
                                                    ->get();
                                                    // echo $value->id;
                                                    // print_r($value);
                                                    // dd($childdevice);
                                                   
                                            
                                                foreach ($childdevice as $value2) {
                                                    $lg2 = DB::table('tr_current_logs')
                                                        ->select('v1','v2','v3','i1','i2','i3','stime','global_device_id')
                                                        ->where('global_device_id', $value2->global_device_id)
                                                        ->orderBy('stime', 'desc')
                                                        ->first();
                                                        // dd($lg2);
                                            
                                                    if ($lg2) {
                                                        // Extract CN number from global_device_id
                                                        if (preg_match('/CN(\d+)$/', $value2->global_device_id, $matches)) {
                                                            $cnNumber = (int)$matches[1];
                                                            $phase = $cnNumber % 3;

                                                            // echo $cnNumber.'\n';

                                            
                                                            // Assign to correct voltage list
                                                            if ($phase == 1) {
                                                                $i1_list[] = $lg2->i1 ?? 0;
                                                            } elseif ($phase == 2) {
                                                                $i2_list[] = $lg2->i2 ?? 0;
                                                            } else { // phase == 0 (e.g., CN3, CN6, CN9)
                                                                $i3_list[] = $lg2->i3 ?? 0;
                                                            }
                                                        }
                                                    }
                                                }

                                            
                                                // Calculate averages
                                                $sum_i1 = count($i1_list) > 0 ? array_sum($i1_list) : 0;
                                                $sum_i2 = count($i2_list) > 0 ? array_sum($i2_list)  : 0;
                                                $sum_i3 = count($i3_list) > 0 ? array_sum($i3_list)  : 0;
                                            
                                                if ($lg1) {
                                                    $graph_data2[] = (object)[
                                                        'global_device_id' => $value->global_device_id,
                                                        'i1' => $sum_i1 !== 0 ? abs($lg1->i1 - $sum_i1) : 0,
                                                        'i2' => $sum_i2 !== 0 ? abs($lg1->i2 - $sum_i2) : 0,
                                                        'i3' => $sum_i3 !== 0 ? abs($lg1->i3 - $sum_i3) : 0,
                                                    ];
                                                }
                                            }
                                            
                      
                    // dd($graph_data2);


        return view('commercialReportView',compact('graph_data','graph_data2'));
    }

    public function deviceTree(Request $request)
    {
        //Device Hierarchy Graph

        $data['tree'] = MeterVisual::whereNull('parent_id')
        ->select('id', 'global_device_id', 'parent_id')
        ->with('children')
        ->get();


        return view('devicetreeReport',compact('data'));
    }
    public function mannualReading(Request $request)
    {
        //Device Hierarchy Graph

        $deviceId = 'TR01'; // or get this from a request input

        $readings = \App\Models\KwhReading::where('global_device_id', $deviceId)
            ->orderBy('rdate')
            ->get();
    
        $kwhpDiffs = [];
        $kwhoDiffs = [];
    
        for ($i = 1; $i < $readings->count(); $i++) {
            $prev = $readings[$i - 1];
            $curr = $readings[$i];
    
            $kwhpDiffs[] = [
                'rdate' => $curr->rdate,
                'pesco_diff' => $curr->pesco_total_kwhp - $prev->pesco_total_kwhp,
                'cisnr_diff' => $curr->total_kwhp - $prev->total_kwhp,
            ];
    
            $kwhoDiffs[] = [
                'rdate' => $curr->rdate,
                'pesco_diff' => $curr->pesco_total_kwho - $prev->pesco_total_kwho,
                'cisnr_diff' => $curr->total_kwho - $prev->total_kwho,
            ];
        }


        $readings = Reading::select('rdate', 
        'pv1', 'pv2', 'pv3', 'cv1', 'cv2', 'cv3',
        'pi1', 'pi2', 'pi3', 'ci1', 'ci2', 'ci3'
        )->orderBy('rdate')->get();



        return view('mannualReadingReport',compact('readings','kwhpDiffs', 'kwhoDiffs','deviceId'));
    }


    // public function technicalReportForm(Request $request)
    // {
    //     $tr_data=MeterVisual::select('global_device_id')->get();

            
    //         $data = [];

    //         if ($request->DeviceId) {
    //             $meter_data=MeterVisual::select('global_device_id',$request->DeviceId)->first();

    //             $data = DB::table('tr_current_logs')
    //             ->select('tr_current_logs.*')
    //             ->where('tr_current_logs.global_device_id',$request->DeviceId)
    //             ->orderBy('tr_current_logs.stime', 'DESC');

    //             $results = DB::table('tr_current_logs')
    //             ->join('meter_visuals', 'tr_current_logs.global_device_id', '=', 'meter_visuals.global_device_id')
    //             ->select('tr_current_logs.*', 'meter_visuals.meter_name') // customize columns as needed
    //             ->get();
    //         }

    //         if ($request->from) {
    //             $fromDate = date('Y-m-d 00:00:00', strtotime($request->from));
    //             $data = $data->where('tr_current_logs.stime', '>=', $fromDate);
    //             }

    //         if ($request->to) {
    //         $toDate = date('Y-m-d 23:59:59', strtotime($request->to));
    //         $data = $data->where('tr_current_logs.stime', '<=', $toDate);
    //         }

    //         if ($request->DeviceId) {
    //         $data = $data->where('tr_current_logs.global_device_id', $request->DeviceId);
    //         }
    //         // dd($data);

    //         if($request->from || $request->to )
    //           $data = $data->limit(30)->get();
    //         else
    //         {
    //             if (!empty($data) ) 
    //             $data = $data->limit(500)->get();
    //         }
    //         // }



    //     return view('technicalReportView',compact('data','tr_data'));
    // }
    // public function commercialReportForm(Request $request)
    // {

    //         $tr_data=MeterVisual::where('installed_on','transformer')->select('global_device_id','installed_on')->get();
    //         $data = [];
    //         $graph_data=[];
    //                         if ($request->DeviceId) {
    //                             // Get transformer meter info
    //                             $transformer = MeterVisual::where('global_device_id', $request->DeviceId)
    //                             ->with('children')
    //                             ->first();

    //                         if (!$transformer) {
    //                             return response()->json(['error' => 'Transformer not found'], 404);
    //                         }

    //                         $transformer->load($this->recursiveChildrenString(6)); // load deep children

    //                         $data = $this->buildHierarchyWithLogs($transformer);

    //                             // dd($data);

    //                             if($data )
    //                             {

    //                                 $logs=$data['logs'];
                                    
                                    
    //                                 if($data && $data['children'] )
    //                                 {
                                        
    //                                     foreach($data['children'] as $row)
    //                                     {
    //                                         if($row && $row['children'] )
    //                                         {
    //                                             foreach($row['children'] as $childrow)
    //                                             {
    //                                                 $grow=[];
    //                                                         $logs2=$childrow['logs'];
    //                                                         $logs2->stime;
    //                                                         $grow['stime']=$logs2->stime;
    //                                                         $grow['parent_id']=$logs->global_device_id;
    //                                                         // $logs->global_device_id;
    //                                                         $grow['child_id']=$logs2->global_device_id;
    //                                                         $grow['i1_difference']=abs($logs2->i1-$logs->i1);
    //                                                         $grow['i2_difference']=abs($logs2->i2-$logs->i2);
    //                                                         $grow['i3_difference']=abs($logs2->i3-$logs->i3);

    //                                                         $graph_data[]=$grow;
    //                                                     }
    //                                                 }
                                                    
                                                    
                                                    
    //                                             }	
    //                                         }
                                            
                                            
    //                             }
                      
    //                 }
    //                 // dd($graph_data);


    //     return view('commercialReportView',compact('data','tr_data','graph_data'));
    // }

    // public function deviceGraphs(Request $request)
    // {

    //         $tr_data=MeterVisual::select('global_device_id')->get();
    //         $data = [];
    //         $graph_data=[];
    //                         if ($request->DeviceId) {
    //                             // Get transformer meter info
    //                             $transformer = MeterVisual::where('global_device_id', $request->DeviceId)
    //                             ->first();
    //                             if (!$transformer) {
    //                                 return response()->json(['error' => 'Transformer not found'], 404);
    //                             }


    //                             $graph_data = TrCurrentLog::where('global_device_id', $request->DeviceId)
    //                                                         ->orderBy('stime','desc')->get();


                           


                                
                      
    //                 }
    //                 // dd($graph_data);


    //     return view('deviceGraphReport',compact('data','tr_data','graph_data'));
    // }
        public function deviceGraphs(Request $request)
    {
        $deviceId = $request->input('DeviceId');
        $range = $request->input('range', 'hourly'); // default to hourly

        $graph_data = collect();

        // Only fetch graph data if deviceId is provided
        if ($deviceId) {
            $query = DB::table('tr_current_logs')
                ->where('global_device_id', $deviceId);
    
            switch ($range) {
                case 'daily': // Hourly average
                    $query->selectRaw('
                        DATE_FORMAT(stime, "%Y-%m-%d %H:00:00") as stime,
                        AVG(v1) as v1, AVG(v2) as v2, AVG(v3) as v3,
                        AVG(i1) as i1, AVG(i2) as i2, AVG(i3) as i3,
                        AVG(pf1) as pf1, AVG(pf2) as pf2, AVG(pf3) as pf3
                    ')
                    ->groupByRaw('DATE_FORMAT(stime, "%Y-%m-%d %H:00:00")');
                    break;
    
                case 'weekly': // Daily average
                    $query->selectRaw('
                        DATE(stime) as stime,
                        AVG(v1) as v1, AVG(v2) as v2, AVG(v3) as v3,
                        AVG(i1) as i1, AVG(i2) as i2, AVG(i3) as i3,
                        AVG(pf1) as pf1, AVG(pf2) as pf2, AVG(pf3) as pf3
                    ')
                    ->groupByRaw('DATE(stime)');
                    break;
    
                case 'monthly': // Weekly average
                    $query->selectRaw('
                        CONCAT(YEAR(stime), "-W", LPAD(WEEK(stime, 1), 2, "0")) as stime,
                        AVG(v1) as v1, AVG(v2) as v2, AVG(v3) as v3,
                        AVG(i1) as i1, AVG(i2) as i2, AVG(i3) as i3,
                        AVG(pf1) as pf1, AVG(pf2) as pf2, AVG(pf3) as pf3
                    ')
                    ->groupByRaw('YEAR(stime), WEEK(stime, 1)');
                    break;
    
                case 'yearly': // Monthly average
                    $query->selectRaw('
                        DATE_FORMAT(stime, "%Y-%m") as stime,
                        AVG(v1) as v1, AVG(v2) as v2, AVG(v3) as v3,
                        AVG(i1) as i1, AVG(i2) as i2, AVG(i3) as i3,
                        AVG(pf1) as pf1, AVG(pf2) as pf2, AVG(pf3) as pf3
                    ')
                    ->groupByRaw('DATE_FORMAT(stime, "%Y-%m")');
                    break;
    
                case 'hourly': // Fine-grained (e.g. 5-minute) average
                default:
                    $query->selectRaw('
                        DATE_FORMAT(stime, "%Y-%m-%d %H:%i:00") as stime,
                        AVG(v1) as v1, AVG(v2) as v2, AVG(v3) as v3,
                        AVG(i1) as i1, AVG(i2) as i2, AVG(i3) as i3,
                        AVG(pf1) as pf1, AVG(pf2) as pf2, AVG(pf3) as pf3
                    ')
                    ->groupByRaw('DATE_FORMAT(stime, "%Y-%m-%d %H:%i:00")');
                    break;
            }
    
            $graph_data = $query->orderBy('stime', 'desc')->get();
        }


        // get device list for the dropdown
        $tr_data=MeterVisual::select('global_device_id')->get(); // replace with actual device table
            

        return view('deviceGraphReport', compact('graph_data', 'tr_data','range'));
    }
    // public function commercialReportForm(Request $request)
    // {
    //     // dd($request->all());
    //     $tr_data=MeterVisual::select('global_device_id')->get();

    //         // $data=TrCurrentLog::orderBy('datetime','DESC')->take(100)->get();
            
    //        // Start with the TrCurrentLog query
    //         $data = DB::table('tr_current_logs')
    //         ->leftJoin('meter_visuals', 'tr_current_logs.global_device_id', '=', 'meter_visuals.global_device_id')
    //         ->select('tr_current_logs.*',  'meter_visuals.dmdt_phase')
    //         ->orderBy('tr_current_logs.stime', 'DESC');

    //         // Apply the filters based on the request parameters
    //         if ($request->from) {
    //         $fromDate = date('Y-m-d 00:00:00', strtotime($request->from));
    //         $data = $data->where('tr_current_logs.stime', '>=', $fromDate);
    //         }

    //         if ($request->to) {
    //         $toDate = date('Y-m-d 23:59:59', strtotime($request->to));
    //         $data = $data->where('tr_current_logs.stime', '<=', $toDate);
    //         }

    //         if ($request->DeviceId) {
    //         $data = $data->where('tr_current_logs.global_device_id', $request->DeviceId);
    //         }

    //         // Limit the number of results and get the data
    //         if($request->from || $request->to )
    //           $data = $data->limit(30)->get();
    //         else
    //         $data = $data->limit(500)->paginate(30);


    //     // $data=Transformer::find($id);
    //     // dd($data);

    //     return view('commercialReportView',compact('data','tr_data'));
    // }


 
       
}
